/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.pipeline.html;

import com.itextpdf.text.Element;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;
import com.itextpdf.tool.xml.CustomContext;
import com.itextpdf.tool.xml.html.TagProcessor;
import com.itextpdf.tool.xml.html.TagProcessorFactory;
import com.itextpdf.tool.xml.pipeline.html.AbstractImageProvider;
import com.itextpdf.tool.xml.pipeline.html.ImageProvider;
import com.itextpdf.tool.xml.pipeline.html.LinkProvider;
import com.itextpdf.tool.xml.pipeline.html.NoImageProviderException;
import com.itextpdf.tool.xml.pipeline.html.NoStackException;
import com.itextpdf.tool.xml.pipeline.html.StackKeeper;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlPipelineContext
implements CustomContext,
Cloneable {
    public static final String BOOKMARK_TREE = "header.autobookmark.RootNode";
    public static final String LAST_MARGIN_BOTTOM = "lastMarginBottom";
    private final LinkedList<StackKeeper> queue;
    private boolean acceptUnknown = true;
    private TagProcessorFactory tagFactory;
    private final List<Element> ctn = new ArrayList<Element>();
    private ImageProvider imageProvider;
    private Rectangle pageSize = PageSize.A4;
    private Charset charset;
    private List<String> roottags = Arrays.asList("body", "div");
    private LinkProvider linkprovider;
    private boolean autoBookmark = true;
    private final Map<String, Object> memory;

    public HtmlPipelineContext() {
        this.queue = new LinkedList();
        this.memory = new HashMap<String, Object>();
    }

    protected TagProcessor resolveProcessor(String tag, String nameSpace) {
        TagProcessor tp = this.tagFactory.getProcessor(tag, nameSpace);
        return tp;
    }

    protected void addFirst(StackKeeper stackKeeper) {
        this.queue.addFirst(stackKeeper);
    }

    protected StackKeeper peek() throws NoStackException {
        try {
            return this.queue.getFirst();
        }
        catch (NoSuchElementException e) {
            throw new NoStackException();
        }
    }

    protected List<Element> currentContent() {
        return this.ctn;
    }

    public boolean acceptUnknown() {
        return this.acceptUnknown;
    }

    protected boolean isEmpty() {
        return this.queue.isEmpty();
    }

    protected StackKeeper poll() throws NoStackException {
        try {
            return this.queue.removeFirst();
        }
        catch (NoSuchElementException e) {
            throw new NoStackException();
        }
    }

    public boolean autoBookmark() {
        return this.autoBookmark;
    }

    public Map<String, Object> getMemory() {
        return this.memory;
    }

    public ImageProvider getImageProvider() throws NoImageProviderException {
        if (null == this.imageProvider) {
            throw new NoImageProviderException();
        }
        return this.imageProvider;
    }

    public HtmlPipelineContext charSet(Charset cSet) {
        this.charset = cSet;
        return this;
    }

    public Charset charSet() {
        return this.charset;
    }

    public Rectangle getPageSize() {
        return this.pageSize;
    }

    public List<String> getRootTags() {
        return this.roottags;
    }

    public LinkProvider getLinkProvider() {
        return this.linkprovider;
    }

    public HtmlPipelineContext setPageSize(Rectangle pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public HtmlPipelineContext clone() throws CloneNotSupportedException {
        HtmlPipelineContext newCtx = new HtmlPipelineContext();
        if (this.imageProvider != null) {
            final String rootPath = this.imageProvider.getImageRootPath();
            newCtx.setImageProvider(new AbstractImageProvider(){

                public String getImageRootPath() {
                    return rootPath;
                }
            });
        }
        if (null != this.charset) {
            newCtx.charSet(Charset.forName(this.charset.name()));
        }
        newCtx.setPageSize(new Rectangle(this.pageSize)).setLinkProvider(this.linkprovider).setRootTags(new ArrayList<String>(this.roottags)).autoBookmark(this.autoBookmark).setTagFactory(this.tagFactory).setAcceptUnknown(this.acceptUnknown);
        return newCtx;
    }

    public HtmlPipelineContext setAcceptUnknown(boolean acceptUnknown) {
        this.acceptUnknown = acceptUnknown;
        return this;
    }

    public HtmlPipelineContext setTagFactory(TagProcessorFactory tagFactory) {
        this.tagFactory = tagFactory;
        return this;
    }

    public HtmlPipelineContext autoBookmark(boolean autoBookmark) {
        this.autoBookmark = autoBookmark;
        return this;
    }

    public HtmlPipelineContext setRootTags(List<String> roottags) {
        this.roottags = roottags;
        return this;
    }

    public HtmlPipelineContext setImageProvider(ImageProvider imageProvider) {
        this.imageProvider = imageProvider;
        return this;
    }

    public HtmlPipelineContext setLinkProvider(LinkProvider linkprovider) {
        this.linkprovider = linkprovider;
        return this;
    }
}

