/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.hibernate.HibernateException;
import org.hibernate.PropertyAccessException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.Setter;
import org.hibernate.util.ReflectHelper;

public class DirectPropertyAccessor
implements PropertyAccessor {
    static /* synthetic */ Class class$java$lang$Object;

    private static Field getField(Class clazz, String name) throws PropertyNotFoundException {
        Field field;
        if (clazz == null || clazz == (class$java$lang$Object == null ? (class$java$lang$Object = DirectPropertyAccessor.class$("java.lang.Object")) : class$java$lang$Object)) {
            throw new PropertyNotFoundException("field not found: " + name);
        }
        try {
            field = clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException nsfe) {
            field = DirectPropertyAccessor.getField(clazz.getSuperclass(), name);
        }
        if (!ReflectHelper.isPublic(clazz, field)) {
            field.setAccessible(true);
        }
        return field;
    }

    public Getter getGetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        return new DirectGetter(DirectPropertyAccessor.getField(theClass, propertyName), theClass, propertyName);
    }

    public Setter getSetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        return new DirectSetter(DirectPropertyAccessor.getField(theClass, propertyName), theClass, propertyName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class DirectSetter
    implements Setter {
        private final transient Field field;
        private final Class clazz;
        private final String name;

        DirectSetter(Field field, Class clazz, String name) {
            this.field = field;
            this.clazz = clazz;
            this.name = name;
        }

        public Method getMethod() {
            return null;
        }

        public String getMethodName() {
            return null;
        }

        public void set(Object target, Object value, SessionFactoryImplementor factory) throws HibernateException {
            try {
                this.field.set(target, value);
            }
            catch (Exception e) {
                throw new PropertyAccessException(e, "could not set a field value by reflection", true, this.clazz, this.name);
            }
        }

        public String toString() {
            return "DirectSetter(" + this.clazz.getName() + '.' + this.name + ')';
        }

        Object readResolve() {
            return new DirectSetter(DirectPropertyAccessor.getField(this.clazz, this.name), this.clazz, this.name);
        }
    }

    public static final class DirectGetter
    implements Getter {
        private final transient Field field;
        private final Class clazz;
        private final String name;

        DirectGetter(Field field, Class clazz, String name) {
            this.field = field;
            this.clazz = clazz;
            this.name = name;
        }

        public Object get(Object target) throws HibernateException {
            try {
                return this.field.get(target);
            }
            catch (Exception e) {
                throw new PropertyAccessException(e, "could not get a field value by reflection", false, this.clazz, this.name);
            }
        }

        public Object getForInsert(Object target, SessionImplementor session) {
            return this.get(target);
        }

        public Method getMethod() {
            return null;
        }

        public String getMethodName() {
            return null;
        }

        public Class getReturnType() {
            return this.field.getType();
        }

        Object readResolve() {
            return new DirectGetter(DirectPropertyAccessor.getField(this.clazz, this.name), this.clazz, this.name);
        }

        public String toString() {
            return "DirectGetter(" + this.clazz.getName() + '.' + this.name + ')';
        }
    }
}

