/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.Date;
import org.springframework.util.ResponseTimeMonitor;

public class ResponseTimeMonitorImpl
implements ResponseTimeMonitor {
    private int accessCount;
    private long initedMillis;
    private int totalResponseTimeMillis = 0;
    private int bestResponseTimeMillis = Integer.MAX_VALUE;
    private int worstResponseTimeMillis = Integer.MIN_VALUE;

    public ResponseTimeMonitorImpl() {
        this.initedMillis = System.currentTimeMillis();
    }

    public Date getLoadDate() {
        return new Date(this.initedMillis);
    }

    public int getAccessCount() {
        return this.accessCount;
    }

    public long getUptimeMillis() {
        return System.currentTimeMillis() - this.initedMillis;
    }

    public int getAverageResponseTimeMillis() {
        if (this.getAccessCount() == 0) {
            return 0;
        }
        return this.totalResponseTimeMillis / this.getAccessCount();
    }

    public int getBestResponseTimeMillis() {
        return this.bestResponseTimeMillis;
    }

    public int getWorstResponseTimeMillis() {
        return this.worstResponseTimeMillis;
    }

    public void recordResponseTime(long responseTimeMillis) {
        ++this.accessCount;
        int iResponseTime = (int)responseTimeMillis;
        this.totalResponseTimeMillis += iResponseTime;
        if (iResponseTime < this.bestResponseTimeMillis) {
            this.bestResponseTimeMillis = iResponseTime;
        }
        if (iResponseTime > this.worstResponseTimeMillis) {
            this.worstResponseTimeMillis = iResponseTime;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("hits=[").append(this.getAccessCount()).append("]; ");
        sb.append("average=[").append(this.getAverageResponseTimeMillis()).append("ms]; ");
        sb.append("best=[").append(this.getBestResponseTimeMillis()).append("ms]; ");
        sb.append("worst=[").append(this.getWorstResponseTimeMillis()).append("ms]");
        return sb.toString();
    }
}

