/*
 * Decompiled with CFR 0.152.
 */
package jcmdline;

import jcmdline.AbstractParameter;
import jcmdline.CmdLineException;
import jcmdline.Strings;

public class IntParam
extends AbstractParameter {
    public static final String DEFAULT_OPTION_LABEL = Strings.get("IntParam.defaultOptionLabel");
    protected int max = Integer.MAX_VALUE;
    protected int min = Integer.MIN_VALUE;

    public IntParam(String tag, String desc) {
        this(tag, desc, Integer.MIN_VALUE, Integer.MAX_VALUE, true, false, false);
    }

    public IntParam(String tag, String desc, boolean optional) {
        this(tag, desc, Integer.MIN_VALUE, Integer.MAX_VALUE, optional, false, false);
    }

    public IntParam(String tag, String desc, boolean optional, boolean multiValued) {
        this(tag, desc, Integer.MIN_VALUE, Integer.MAX_VALUE, optional, multiValued, false);
    }

    public IntParam(String tag, String desc, boolean optional, boolean multiValued, boolean hidden) {
        this(tag, desc, Integer.MIN_VALUE, Integer.MAX_VALUE, optional, multiValued, hidden);
    }

    public IntParam(String tag, String desc, int min, int max) {
        this(tag, desc, min, max, true, false, false);
    }

    public IntParam(String tag, String desc, int min, int max, boolean optional) {
        this(tag, desc, min, max, optional, false, false);
    }

    public IntParam(String tag, String desc, int min, int max, boolean optional, boolean multiValued) {
        this(tag, desc, min, max, optional, multiValued, false);
    }

    public IntParam(String tag, String desc, int min, int max, boolean optional, boolean multiValued, boolean hidden) {
        this.setTag(tag);
        this.setMin(min);
        this.setMax(max);
        this.setDesc(desc);
        this.setOptional(optional);
        this.setMultiValued(multiValued);
        this.setHidden(hidden);
        this.setOptionLabel(DEFAULT_OPTION_LABEL);
    }

    public IntParam(String tag, String desc, int[] acceptableValues) {
        this(tag, desc, acceptableValues, true, false, false);
    }

    public IntParam(String tag, String desc, int[] acceptableValues, boolean optional) {
        this(tag, desc, acceptableValues, optional, false, false);
    }

    public IntParam(String tag, String desc, int[] acceptableValues, boolean optional, boolean multiValued) {
        this(tag, desc, acceptableValues, optional, multiValued, false);
    }

    public IntParam(String tag, String desc, int[] acceptableValues, boolean optional, boolean multiValued, boolean hidden) {
        this.setTag(tag);
        this.setAcceptableIntValues(acceptableValues);
        this.setDesc(desc);
        this.setOptional(optional);
        this.setMultiValued(multiValued);
        this.setHidden(hidden);
        this.setOptionLabel(DEFAULT_OPTION_LABEL);
    }

    public void setMin(int min) {
        if (min > this.max) {
            throw new IllegalArgumentException(Strings.get("IntParam.maxLessThanMin", new Object[]{this.tag}));
        }
        this.min = min;
    }

    public int intValue() {
        if (!this.set) {
            throw new RuntimeException(Strings.get("IntParam.valueNotSet", new Object[]{this.tag}));
        }
        return Integer.parseInt((String)this.values.get(0));
    }

    public int[] intValues() {
        int[] vals = new int[this.values.size()];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = Integer.parseInt((String)this.values.get(i));
        }
        return vals;
    }

    public int getMin() {
        return this.min;
    }

    public void setMax(int max) {
        if (this.min > max) {
            throw new IllegalArgumentException(Strings.get("IntParam.maxLessThanMin", new Object[]{this.tag}));
        }
        this.max = max;
    }

    public int getMax() {
        return this.max;
    }

    public void setAcceptableIntValues(int[] intValues) {
        String[] sValues = new String[intValues.length];
        for (int i = 0; i < intValues.length; ++i) {
            sValues[i] = Integer.toString(intValues[i]);
        }
        this.setAcceptableValues(sValues);
    }

    public int[] getAcceptableIntValues() {
        String[] sValues = this.getAcceptableValues();
        int[] intValues = new int[sValues.length];
        for (int i = 0; i < sValues.length; ++i) {
            intValues[i] = Integer.parseInt(sValues[i]);
        }
        return intValues;
    }

    public void validateValue(String val) throws CmdLineException {
        int offset = 0;
        while (val.startsWith("0", offset)) {
            ++offset;
        }
        super.validateValue(val.substring(offset));
        CmdLineException exception = new CmdLineException(Strings.get("IntParam.validValues", new Object[]{this.tag, new Integer(this.min), new Integer(this.max)}));
        int intVal = 0;
        try {
            intVal = Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            throw exception;
        }
        if (intVal < this.min || intVal > this.max) {
            throw exception;
        }
    }
}

