/*
 * Decompiled with CFR 0.152.
 */
package com.topaz.sigplus.util;

import com.topaz.sigplus.util.SigCrypt;
import com.topaz.sigplus.util.SigDataPoint;
import com.topaz.sigplus.util.SigDataType;
import com.topaz.sigplus.util.SigDrawParameters;
import com.topaz.sigplus.util.SigInfo;
import com.topaz.sigplus.util.SigInputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class SigReader {
    private int compressionMode;
    private SigCrypt cryptor;
    static final int TopazDataTag = 65535;
    static final int TopazPressureTag = 0;
    static final int TopazTimeTag = 1;

    public void readSigFromByteArray(byte[] buffer, SigDataType sig, SigDrawParameters displayParams, SigDrawParameters imageParams) {
        byte[] sigArray = this.cryptor.decryptBuffer(buffer);
        if (sigArray == null) {
            return;
        }
        if (this.compressionMode == 0) {
            this.readSigUncompressed(sigArray, sig, displayParams, imageParams);
        } else {
            this.readSigCompressed(sigArray, sig, displayParams, imageParams);
        }
    }

    public boolean readSigFromFile(String fileName, SigDataType sig, SigDrawParameters displayParams, SigDrawParameters imageParams) {
        try {
            FileInputStream file = new FileInputStream(fileName);
            byte[] buffer = new byte[file.available()];
            file.read(buffer);
            this.readSigFromByteArray(buffer, sig, displayParams, imageParams);
            file.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public SigReader(int compMode, SigCrypt crypt) {
        this.compressionMode = compMode;
        this.cryptor = crypt;
    }

    public String loadAnnotationString(SigInputStream stream, int length) {
        String str = "";
        int i = 0;
        while (i < length) {
            int newChar = stream.readBinaryByte();
            if (this.compressionMode == 0 && newChar == 13) {
                int nextChar = stream.readBinaryByte();
                if (nextChar != 10) {
                    str = String.valueOf(str) + (char)newChar;
                    ++i;
                }
                newChar = nextChar;
            }
            str = String.valueOf(str) + (char)newChar;
            ++i;
        }
        return str;
    }

    public void loadSigInfo(SigInputStream stream, SigDataType sig, SigDrawParameters displayParams, SigDrawParameters imageParams) {
        sig.setAnnotation("");
        sig.setTimeStamp("");
        int strLength = stream.readBinaryUnsignedByte();
        if (strLength == -1) {
            return;
        }
        String str = this.loadAnnotationString(stream, strLength);
        sig.setTimeStamp(str);
        displayParams.setTimeStampX(stream.readBinaryShort());
        displayParams.setTimeStampY(stream.readBinaryShort());
        displayParams.setTimeStampSize(stream.readBinaryShort());
        if (stream.readBinaryShort() == 0) {
            displayParams.setTimeStamp(false);
        } else {
            displayParams.setTimeStamp(true);
        }
        imageParams.setTimeStampX(stream.readBinaryShort());
        imageParams.setTimeStampY(stream.readBinaryShort());
        imageParams.setTimeStampSize(stream.readBinaryShort());
        if (stream.readBinaryShort() == 0) {
            imageParams.setTimeStamp(false);
        } else {
            imageParams.setTimeStamp(true);
        }
        strLength = stream.readBinaryUnsignedByte();
        str = this.loadAnnotationString(stream, strLength);
        sig.setAnnotation(str);
        displayParams.setAnnotationX(stream.readBinaryShort());
        displayParams.setAnnotationY(stream.readBinaryShort());
        displayParams.setAnnotationSize(stream.readBinaryShort());
        if (stream.readBinaryShort() == 0) {
            displayParams.setAnnotation(false);
        } else {
            displayParams.setAnnotation(true);
        }
        imageParams.setAnnotationX(stream.readBinaryShort());
        imageParams.setAnnotationY(stream.readBinaryShort());
        imageParams.setAnnotationSize(stream.readBinaryShort());
        if (stream.readBinaryShort() == 0) {
            imageParams.setAnnotation(false);
        } else {
            imageParams.setAnnotation(true);
        }
    }

    public void readSigCompressed(byte[] buffer, SigDataType sig, SigDrawParameters displayParams, SigDrawParameters imageParams) {
        SigInputStream sigStream = new SigInputStream(buffer);
        SigInfo sigData = new SigInfo();
        sig.clearSig();
        int numStrokes = sigStream.readBinaryShort();
        if (numStrokes > 12288) {
            return;
        }
        int i = 0;
        while (i < numStrokes) {
            sig.addNewStroke();
            int numPoints = sigStream.readBinaryShort();
            int x = sigStream.readBinaryShort();
            int y = sigStream.readBinaryShort();
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            sig.addNewPoint(x, y, 0L);
            int j = 1;
            while (j < numPoints) {
                int dx = sigStream.readBinaryByte();
                int dy = sigStream.readBinaryByte();
                y += dy;
                if ((x += dx) < 0) {
                    x = 0;
                }
                if (y < 0) {
                    y = 0;
                }
                sig.addNewPoint(x, y, 0L);
                ++j;
            }
            ++i;
        }
        this.loadSigInfo(sigStream, sig, displayParams, imageParams);
        this.loadPressureDataFromFile(sigStream, sig);
        this.loadTimeDataFromFile(sigStream, sig);
        sig.getSigData(sigData);
        sig.setLastPointDrawn(sigData.numPoints - 1);
    }

    public void readSigUncompressed(byte[] buffer, SigDataType sig, SigDrawParameters displayParams, SigDrawParameters imageParams) {
        SigInputStream sigStream = new SigInputStream(buffer);
        SigInfo sigData = new SigInfo();
        sig.clearSig();
        int numPoints = sigStream.readAsciiInt();
        int numStrokes = sigStream.readAsciiInt();
        int i = 0;
        while (i < numPoints) {
            int x = sigStream.readAsciiInt();
            int y = sigStream.readAsciiInt();
            sig.addNewPoint(x, y, 0L);
            ++i;
        }
        i = 0;
        while (i < numStrokes) {
            int stroke = sigStream.readAsciiInt();
            sig.addNewStrokeByIndex(stroke);
            ++i;
        }
        sigStream.readBinaryShort();
        this.loadSigInfo(sigStream, sig, displayParams, imageParams);
        sig.getSigData(sigData);
        sig.setLastPointDrawn(sigData.numPoints - 1);
    }

    public void loadPressureDataFromFile(SigInputStream sourceFile, SigDataType sig) {
        sourceFile.mark(256);
        int temp = sourceFile.readBinaryShort();
        if (temp != 65535) {
            sourceFile.reset();
            return;
        }
        temp = sourceFile.readBinaryShort();
        if (temp != 0) {
            sourceFile.reset();
            return;
        }
        int i = 0;
        while (i < sig.points.size()) {
            int v = sourceFile.readBinaryInt();
            SigDataPoint pnt = (SigDataPoint)sig.points.get(i);
            pnt.p = v;
            sig.points.setElementAt(pnt, i);
            ++i;
        }
    }

    public void loadTimeDataFromFile(SigInputStream sourceFile, SigDataType sig) {
        sourceFile.mark(256);
        int temp = sourceFile.readBinaryShort();
        if (temp != 65535) {
            sourceFile.reset();
            return;
        }
        temp = sourceFile.readBinaryShort();
        if (temp != 1) {
            sourceFile.reset();
            return;
        }
        int i = 0;
        while (i < sig.points.size()) {
            int v = sourceFile.readBinaryInt();
            SigDataPoint pnt = (SigDataPoint)sig.points.get(i);
            pnt.t = v;
            sig.points.setElementAt(pnt, i);
            ++i;
        }
    }
}

