/*
 * Decompiled with CFR 0.152.
 */
package com.topaz.sigplus.microutil;

import com.topaz.sigplus.microutil.SigDataPoint;
import java.util.Vector;

public class MicroSigDataType {
    public Vector points = new Vector();
    public Vector strokes = new Vector();
    String annotation = "";
    String timeStamp = "";
    boolean saveSigInfo = false;
    int lastPointDrawn = 0;

    synchronized void addNewPoint(int newX, int newY) {
        SigDataPoint pt = new SigDataPoint(newX, newY);
        this.points.addElement(pt);
    }

    synchronized void addNewStroke() {
        Integer strokeIdx = new Integer(this.points.size());
        this.strokes.addElement(strokeIdx);
    }

    synchronized void addNewStrokeByIndex(int index) {
        Integer strokeIdx = new Integer(index);
        this.strokes.addElement(strokeIdx);
    }

    public synchronized void clearSig() {
        this.points.removeAllElements();
        this.strokes.removeAllElements();
    }

    public int getNumberOfPointsInStroke(int stroke) {
        int numStrokes = this.strokes.size();
        if (stroke >= numStrokes) {
            return 0;
        }
        if (stroke == numStrokes - 1) {
            return this.points.size() - (Integer)this.strokes.elementAt(stroke);
        }
        return (Integer)this.strokes.elementAt(stroke + 1) - (Integer)this.strokes.elementAt(stroke);
    }

    synchronized int getStrokeForPoint(int pnt) {
        int pntsSoFar = 0;
        int pntsToNext = 0;
        int i = 0;
        while (i < this.strokes.size()) {
            pntsToNext = pntsSoFar + (Integer)this.strokes.elementAt(i);
            if (pnt >= pntsSoFar && pnt < pntsToNext) {
                return i;
            }
            ++i;
        }
        return i - 1;
    }

    public int totalPoints() {
        return this.points.size();
    }

    public boolean isNewData() {
        if (this.points.size() == 0) {
            return false;
        }
        return this.lastPointDrawn != this.points.size() - 1;
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(String newValue) {
        this.timeStamp = newValue;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String newValue) {
        this.annotation = newValue;
    }

    public boolean getSaveSigInfo() {
        return this.saveSigInfo;
    }

    public void setSaveSigInfo(boolean trueToSave) {
        this.saveSigInfo = trueToSave;
    }

    public SigDataPoint getPoint(int stroke, int point) {
        SigDataPoint BlankPoint = new SigDataPoint(0, 0);
        if (stroke >= this.strokes.size()) {
            return BlankPoint;
        }
        int ptIdx = (Integer)this.strokes.elementAt(stroke) + point;
        if (ptIdx >= this.points.size()) {
            return BlankPoint;
        }
        return (SigDataPoint)this.points.elementAt(ptIdx);
    }
}

