/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.hifi;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.XPScrollBarUI;
import com.jtattoo.plaf.hifi.HiFiScrollButton;
import java.awt.Color;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class HiFiScrollBarUI
extends XPScrollBarUI {
    public static ComponentUI createUI(JComponent c) {
        return new HiFiScrollBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        Color[] colors = AbstractLookAndFeel.getTheme().getThumbColors();
        rolloverColors = new Color[colors.length];
        dragColors = new Color[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            HiFiScrollBarUI.rolloverColors[i] = ColorHelper.brighter(colors[i], 8.0);
            HiFiScrollBarUI.dragColors[i] = ColorHelper.darker(colors[i], 8.0);
        }
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        if (AbstractLookAndFeel.getTheme().isMacStyleScrollBarOn()) {
            return super.createDecreaseButton(orientation);
        }
        return new HiFiScrollButton(orientation, this.scrollBarWidth);
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        if (AbstractLookAndFeel.getTheme().isMacStyleScrollBarOn()) {
            return super.createIncreaseButton(orientation);
        }
        return new HiFiScrollButton(orientation, this.scrollBarWidth);
    }

    @Override
    protected Color getFrameColor() {
        Color frameColor = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getButtonBackgroundColor(), 8.0);
        if (this.isDragging) {
            return ColorHelper.darker(frameColor, 8.0);
        }
        if (this.isRollover) {
            return ColorHelper.brighter(frameColor, 16.0);
        }
        return frameColor;
    }
}

